#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// noise blobby blobsMod01.fsh   by  SnoopethDuckDuck
//https://www.shadertoy.com/view/7l3XW2
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define pi 3.14159

float thc(float a, float b) {
    return tanh(a * cos(b)) / tanh(a);
}

float ths(float a, float b) {
    return tanh(a * sin(b)) / tanh(a);
}

vec3 thc(float a, vec3 b) {
    return tanh(a * cos(b)) / tanh(a);
}

float h21 (vec2 a) {
    return fract(sin(dot(a.xy, vec2(12.9898, 78.233))) * 43758.5453123);
}

float h21 (float a, float b, float sc) {
    a = mod(a, sc); b = mod(b, sc);
    return fract(sin(dot(vec2(a, b), vec2(12.9898, 78.233)))*43758.5453123);
}

float sdSegment( in vec2 p, in vec2 a, in vec2 b )
{
    vec2 pa = p-a, ba = b-a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h );
}

vec2 pnt(vec2 ipos, float sc) {
    float h = h21(ipos.x, ipos.y, sc);
    float t = iTime + 10. * h;
    float k = 1.5 +  h;
    return 0.4 * vec2(thc(4. * (1.-h), 100. + k * t), 
                      ths(4. * h, 100. + (1.-k) * t));
}

vec3 pal( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b * cos(6.28318*(c*t+d) );
}

float fn(vec2 p, float time) {
    float m = fract(h21(p) + time);
    return m * m * (3. - 2. * m);
}

float test(vec2 p, float time, float a) {
    return h21(floor(h21(p) + time) + a + 0.01 * p);
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - 0.5 * iResolution.xy)/ iResolution.y;
    vec2 ouv = uv;
   // ouv *= 2.3;
        
    float a = atan(uv.y, uv.x);
    float r = length(uv); 
    uv.y += 0.02 * iTime; // 0.06

    float sc = 20.;
    vec2 fpos = fract(sc * uv) - 0.; // dont include -0.5, so box lerp is easier
    vec2 ipos = floor(sc * uv) + 0.;    
    
    // box corner points
    vec2 lp = ipos + vec2(1.,0.);
    vec2 tp = ipos + vec2(0.,1.);
    vec2 tlp = ipos + vec2(1.);
    vec2 idp = ipos;

    float time = 0.5 * iTime;
    
    // corner value 1: floor(time)
    float l = test(lp, time, 0.);
    float t = test(tp, time, 0.);
    float tl = test(tlp, time, 0.);
    float id = test(idp, time, 0.);
    
    // corner value 2: floor(time) + 1.
    float l2 = test(lp, time, 1.);
    float t2 = test(tp, time, 1.);
    float tl2 = test(tlp, time, 1.);
    float id2 = test(idp, time, 1.);
    
    // lerp between corner values, present and future
    l = mix(l, l2, fn(lp, time));
    t = mix(t, t2, fn(tp, time));
    tl = mix(tl, tl2, fn(tlp, time));
    id = mix(id, id2, fn(idp, time));
    
    // smooth fpos so end points meet continuously
    vec2 sfpos = fpos * fpos * (3. - 2. * fpos);

    // box lerp corner values
    float v = l  * sfpos.x      * (1.-sfpos.y)
     	    + t  * (1.-sfpos.x) * sfpos.y
     	    + tl * sfpos.x      * sfpos.y
      	    + id * (1.-sfpos.x) * (1.-sfpos.y);
    
    // remove me to see grid version
    v += 0.4 + 1.2 * (1. - length(ouv)) * cos(20. * length(ouv) + 0. * atan(ouv.y, ouv.x) - 2. * iTime);
    
    float k = 0.1; 
    float s = smoothstep(-k, k, -v + 0.3);
    s = pow(4. * (1.-s) * s, 2.);
    
    float k2 = 0.1;
    s = step(0.4, s); //smoothstep(-k2, k2, s - 0.4);

    vec3 col = vec3(s);
    vec3 e = vec3(1.);
    col = s * pal(h21(vec2(ipos)), e, e, e, vec3(0.,0.33,0.66));
    
    
    fragColor = vec4(col, 1.); //vec4(v);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

